<?php

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Flshop extends CI_Controller {

public $folpath="./uploadImage/";
public $company_id;
public $fp_id;
public $user_id;
public $user_type_id;


/*----------------------------------------------------------------------------------*/
function __construct()
{
	parent::__construct();
	
	$this->company_id=$this->session->userdata("company_id");
	$this->fp_id=$this->session->userdata("fp_id");
	$this->user_id=$this->session->userdata("user_id");
	$this->user_type_id=$this->session->userdata("user_type_id");
}
/*----------------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------------*/
function index_ajax($page)
{
	$data["sess_user_id"]=$this->session->userdata("user_id");
	$this->load->view("flshop/ajax/$page");
}
/*----------------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------------*/
function index($page,$param)
{
	$this->check_login();
	//echo $param; exit;
	$data["param"]=$param;
	
	$data["sess_user_id"]=$this->session->userdata("user_id");
	$this->load->view("flshop/$page",$data);
}
/*----------------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------------*/
function check_login($module_name)
{

//modules allowed with fp_id set
$arr_allowed=array("company","financial_period");	

//echo "<pre/>";
//var_export($this->session->all_userdata());
			
//session company_id required.............................................
if(!$this->session->userdata("company_id"))
{
	$this->session->set_flashdata('message','Invalid Login Details!');
	redirect('login');
}
//........................................................................


//session fp_id required.....................................................
if(!$this->session->userdata("fp_id") && !in_array($module_name,$arr_allowed))
{
	$this->session->set_flashdata('dmsg','<span class=text_info_1>Please create/activate financial period for current company</span>');
	redirect(base_url()."flshop/module_list/financial_period/");	
}
//........................................................................


}
/*----------------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------------*/
function module_list($module_name='users',$order_by,$order)
{
	
	$this->check_login($module_name);
	
	//order_by and order section..............................................................
	$order_by=$order_by ? $order_by : $_REQUEST["order_by"];
	$order_by=$order_by ? $order_by : $this->session->userdata($module_name."_order_by");
	$order_by=$order_by ? $order_by : "cr_date";
	
	$order=$order ? $order : $_REQUEST["order"];
	$order=$order ? $order : $this->session->userdata($module_name."_order");
	$order=$order ? $order : "desc";
	//end order_by and order section..........................................................
	
	set_filter_params($module_name,$order_by,$order,$this);
	
	//foreach($this->session->all_userdata() as $k=>$v){echo "$k=>$v<br/>";}
	
	$data["sess_user_id"]=$this->session->userdata("user_id");
	
	//echo "<br/>page_number: ".$page_number;
	
	
	//.......................................................................................
	$config['base_url'] = base_url().'flshop/module_list/'.$module_name."/$order_by/$order/";
	$page_number=$this->uri->segment(6);
	$config['uri_segment'] = 6;//for page number selected option

	$config['per_page'] = '100';
	$config['full_tag_open'] = '<p>';
	$config['full_tag_close'] = '</p>';
	
	//to pass parameters in pagination like filtering drop downs
	if($_POST[order])
	{
		$config['suffix'] = '?'.http_build_query($_POST, '', "&");
	}
	else //if($_GET[order])
	{
		$config['suffix'] = '?'.http_build_query($_GET, '', "&");
	}
	//......................................................................................
		
	
	$config['total_rows']=$this->common->module_list($config['per_page'],$page_number,$module_name,$order_by,$order,"count");
	$data['records']=$this->common->module_list($config['per_page'],$page_number,$module_name,$order_by,$order,"limit");
	
	$data['order_by']=$order_by;
	$data['order']=$order;
	
	$this->pagination->initialize($config); 
	$this->load->view('flshop/'.$module_name,$data);
	
}
/*----------------------------------------------------------------------------------*/




/*module actions--------------------------------------------------------------------*/
function module_form($module_name='users',$stat='',$id='',$filename, $field_name)
{
	$this->check_login($module_name);
	
	//echo "<pre/>"; var_export($_REQUEST); exit;
	
	//pass session parameters to be used in forms................
	$data["sess_company_id"]=$this->session->userdata("company_id");
	$data["sess_fp_id"]=$this->session->userdata("fp_id");
	$data["sess_user_id"]=$this->session->userdata("user_id");
	//...........................................................
	
	//for first time install purpose
	$sess_user_install=$this->session->userdata("user_install");
	
	//new........................................................................
	if($stat=='' || $stat=='new'){
		$this->load->view('flshop/'.$module_name.'_form',$data);
	}
	//edit........................................................................
	else if($stat=='edit' || stristr($stat,'print') )
	{
		$data['record']=$this->db->get_where('dt_'.$module_name,array('id'=>$id))->row_array();
		$arr_upload_fields = $this->common->get_upload_fields('dt_'.$module_name);
		
		//upload fields to show files
		foreach($arr_upload_fields as $k=>$v){
			$data['arr_'.$v]=get_arr_file_list($data['record'][$v],$this->folpath);
		}
		
		if($stat=="new" || $stat=="edit")
		{
			$this->load->view('flshop/'.$module_name.'_form',$data);
		}
		else
		{
			$this->load->view('flshop/'.$module_name.'_'.$stat,$data);
		}
	}
	//end edit......................................................................
	//delete uploaded file.........................................................
	else if($stat=='delete_file')
	{
		//echo $filename;
		$data['record']=$this->common->delete_file('dt_'.$module_name,'id',$id,$filename,$field_name,'uploadImage/');
		if($data['record']){
			$this->session->set_flashdata("msg","File Deleted Successfully.");
			redirect(base_url().'flshop/module_form/'.$module_name.'/edit/'.$id);
		}
	}
	//delete record...............................................................
	else if($stat=='delete')
	{
		$msg=$this->common->delete_record($module_name,'id',$id,$this->folpath);
		//echo $msg; exit;
		$this->session->set_flashdata("msg","<center>$msg</center>");
		
		if($_REQUEST["redirect"])
		{
			redirect($_REQUEST["redirect"]);
		}
		else
		{
			redirect(base_url().'flshop/module_list/'.$module_name.'/id/asc');
		}
	}
	//save.......................................................................
	else if($stat=='save')
	{
	    //echo $filename; exit;
		//$this->load->model('common','',TRUE);
		if($_REQUEST["duplicate_fields"]){
			$duplicate_fields=explode(",",$_REQUEST["duplicate_fields"]);
		}
		else{
			$duplicate_fields=array("id");
		}
		//var_export($duplicate_fields); 
		//exit;
		list($msg,$id)=$this->common->RecordSave($module_name,$id,$duplicate_fields,'id');
		//echo $msg;

		if($msg)
		{
			/*update.....................................................................................*/
			if($msg=='update')
			{
				$this->session->set_flashdata("msg","Record Updated Successfully.");
				if($sess_user_install){
					redirect(base_url()."login");
				}
				else{
					if($_REQUEST["redirect"]){
						redirect($_REQUEST["redirect"]);
					}
					else{
						redirect(base_url()."flshop/module_form/".$module_name."/edit/$id");
					}
				}
			}
			/*insert.....................................................................................*/
			else if($msg=='insert')
			{
				$this->session->set_flashdata("msg","Record Saved Successfully.");
				
				if($sess_user_install){
					redirect(base_url()."login");
				}
				else{
					if($_REQUEST["redirect"]){
						redirect($_REQUEST["redirect"]);
					}
					else{
						//redirect(base_url()."flshop/module_form/".$module_name."/");
						redirect(base_url()."flshop/module_form/".$module_name."/edit/$id");
					}
				}
			}
			/*..........................................................................................*/
			else 
			{
				$this->session->set_flashdata("msg","<font color=red>".$msg."</font>");
				redirect(base_url()."flshop/module_form/".$module_name."/edit/$id");
			}
			/*..........................................................................................*/
		}
		//end if msg
	}
	//end stat save...................................................................
	
	
}
/*----------------------------------------------------------------------------------*/




/*----------------------------------------------------------------------------------*/
function test_query()
{
	$this->load->view('flshop/test_query');
}
/*----------------------------------------------------------------------------------*/



}
?>