<!DOCTYPE html>  
<html>  
<head>  
<title>User-editable Rectangle</title>  
<meta name="viewport" content="initial-scale=1.0, user-scalable=no">  
<meta charset="utf-8">  
<style>  
html, body {  
height: 100%;  
margin: 0;  
padding: 0;  
}  
#map {  
height: 99%; 
width: 99%;
}  
</style>  

<script async defer
src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDTwbEnr61ZMGwD5kC89JULP2gCJpqhYow&libraries=places,drawing,geometry&callback=initMap">
</script>

<script>   

//init map----------------------------------------------------------------------------------------------------
function initMap() {
var lat_lng = {lat: 43.5427, lng: -96.6905};
var map = new google.maps.Map(document.getElementById('map'), {  
center: lat_lng,
zoom: 18,
mapTypeId: 'hybrid'
});  

var width=200;
var height=100;

//1 degree=364320 feet
var width_degree=width/364320;
var height_degree=height/364320;
//alert("width_degree: "+width_degree+", height_degree: "+height_degree);

var mylat = map.getCenter().lat(); 
var mylng = map.getCenter().lng();
//alert(mylat+', '+mylng);

var north=mylat+height_degree;
var south=mylat-height_degree;
var east=mylng+width_degree;
var west=mylng-width_degree;

//alert(north+', '+south+', '+east+', '+west);

var bounds = {
  north: north,
  south: south,
  east: east,
  west: west
}; 

var rectangle = new google.maps.Rectangle({  
bounds: bounds,
strokeColor: '#FF0000',    
strokeOpacity: 0.8,    
strokeWeight: 2,    
fillColor: '#FF0000',    
fillOpacity: 0.35,
draggable: true,
editable: true,  // Make it editable, set its editable property to true
map:map
});   

rectangle.setMap(map);  

google.maps.event.addDomListener(rectangle, 'rectanglecomplete', function(event) {

var bounds = event.overlay.getBounds();
var start = bounds.getNorthEast();

alert(start);

});

}  
//end init map------------------------------------------------------------------------------------------------

</script>  


</head>  
<body>  
<div id="map"></div>  
</body>  
</html> 