<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');


//get sorting class name depending on matching field order by and order--------------------------------------
function get_sorting_class($field,$order_by,$order)
{

//echo "$field,$order_by,$order";

//field matching
if($field==$order_by)
{
	if($order=="asc")
	{
		return "sorting_asc";
	}
	else
	{
		return "sorting_desc";
	}
	
}
//not matching
else
{
	return "sorting";
}


}
//end get sorting class name depending on matching field order by and order----------------------------------




//get lat lon from google by providing zip code------------------------------------------------------------
function get_latitude_longitude_for_zip($zipcode)
{

$zipcode=str_pad($zipcode,5,'0',STR_PAD_LEFT);

$url = "https://maps.googleapis.com/maps/api/geocode/json?address=".$zipcode."&sensor=false";
//echo $url."<br/><br/>";

$details=file_get_contents($url);

$result = json_decode($details,true);
$lat=$result['results'][0]['geometry']['location']['lat'];
$lng=$result['results'][0]['geometry']['location']['lng'];
//echo "lat: ".$lat;

//var_export($result);

return array($lat,$lng);

}
//end get lat lon from google by providing zip code--------------------------------------------------------



//returns entire url with query string--------------------------------------------------------------------
function get_current_url()
{

$CI=& get_instance();

$current_url=$CI->session->userdata("current_url");
$query_string=$CI->session->userdata("query_string");
$query_string=$query_string ? "/?".$query_string : '';
$redirect=$current_url.$query_string;

return $redirect;

}
//end returns entire url with query string--------------------------------------------------------------------




//sets current url with query string--------------------------------------------------------------------
function set_current_url()
{

$CI=& get_instance();

$query_string=$_SERVER['QUERY_STRING'];
$CI->session->set_userdata("query_string",$query_string);
$CI->session->set_userdata("current_url",current_url());

}
//end sets current url with query string--------------------------------------------------------------------




//--------------------------------------------------------------------------------------------------------
function display_partial($str,$len)
{
$str_len=strlen($str);
$str=substr($str,0,$len);

if($str_len>$len)
{
	$str.="...";
}

return $str;
}
//--------------------------------------------------------------------------------------------------------




//form view to list view with last order by, order-------------------------------------------------------
//back_to_list($controller_name,$module_name,$module_caption,$params)
function back_to_list($controller_name,$module_name,$module_caption,$params)
{
	$CI=& get_instance();
	
	//echo "$controller_name,$module_name,$module_caption,$params";

	$order_by=$CI->session->userdata($module_name."_order_by");
	//$order_by=$order_by ? $order_by : "cr_date";
	$order=$CI->session->userdata($module_name."_order");
	//$order=$order ? $order : "desc";
	
	
	//echo "<a href=".base_url()."$controller_name/module_list/$module_name/$order_by/$order".$params.">Back To $module_caption List</a>";
	echo "<a href=".base_url()."$controller_name/module_list/$module_name".$params.">Back To $module_caption List</a>";
	
	//unset previous values
	//$CI->session->unset_userdata("order_by");
	//$CI->session->unset_userdata("order");
}
//-------------------------------------------------------------------------------------------------------


//-------------------------------------------------------------------------------------------------------
//subtract day, month or year to a particular date
function get_date_sub_params($date,$month_sub,$day_sub,$year_sub)
{
	$arr=explode("/",$date);
	
	if(DATE_FORMAT_PHP=='d/m/Y')
	{
		return date(DATE_FORMAT_PHP, mktime(0,0,0,$arr[1]-$month_sub,$arr[0]-$day_sub,$arr[2]-$year_sub));
	}
	else
	{
		return date(DATE_FORMAT_PHP, mktime(0,0,0,$arr[0]-$month_sub,$arr[1]-$day_sub,$arr[2]-$year_sub));
	}
}
//-------------------------------------------------------------------------------------------------------




//-------------------------------------------------------------------------------------------------------
//add day, month or year to a particular date
function get_date_add_params($date,$month_add,$day_add,$year_add)
{
	$arr=explode("/",$date);
	
	if(DATE_FORMAT_PHP=='d/m/Y')
	{
		return date(DATE_FORMAT_PHP, mktime(0,0,0,$arr[1]+$month_add,$arr[0]+$day_add,$arr[2]+$year_add));
	}
	else
	{
		return date(DATE_FORMAT_PHP, mktime(0,0,0,$arr[0]+$month_add,$arr[1]+$day_add,$arr[2]+$year_add));
	}
}
//-------------------------------------------------------------------------------------------------------




//-------------------------------------------------------------------------------------------------------
function date_to_shortmonth($date,$date_format)
{
	//echo "$date,$date_format";
	if($date_format=="ddmmyyyy")
	{
		return ddmmyyyy_to_shortmonth($date);
	}
	else if($date_format=="mmddyyyy")
	{
		return mmddyyyy_to_shortmonth($date);
	}
}
//-------------------------------------------------------------------------------------------------------




//-------------------------------------------------------------------------------------------------------
function ddmmyyyy_to_mysql($get_date)
{
    if(!$get_date){return;}
	$dt_explode=explode("/",$get_date);
	$dt_explode=$dt_explode[2]."-".$dt_explode[1]."-".$dt_explode[0];
	 
	return strftime("%Y-%m-%d",strtotime($dt_explode));	
}
//-------------------------------------------------------------------------------------------------------




//-------------------------------------------------------------------------------------------------------
function ddmmyyyy_to_shortmonth($get_date)
{
    if(!$get_date){return;}
	$dt_explode=explode("/",$get_date);
	$dt_explode=$dt_explode[2]."-".$dt_explode[1]."-".$dt_explode[0];
	 
	return strftime("%d-%b-%Y",strtotime($dt_explode));	
}
//-------------------------------------------------------------------------------------------------------




//module caption of listing and forms--------------------------------------------------------------------
function get_module_caption($module_name)
{
	$module_caption=preg_replace("/_hdr/"," ",$module_name);
	$module_caption=preg_replace("/_/"," ",$module_caption);
	
	return ucwords($module_caption);
}
//-------------------------------------------------------------------------------------------------------




/*--------------------------------------------------------------------------------------------------------*/
function set_filter_params($module_name,$order_by,$order,$this1)
{
	$this1->session->set_userdata($module_name."_order_by",$order_by);
	$this1->session->set_userdata($module_name."_order",$order);
	
	
	//start_date............................................................................
	if(!is_null($_REQUEST["start_date"]) && $_REQUEST["start_date"]=='')
	{
		$this1->session->unset_userdata($module_name."_start_date");
	}
	else if($_REQUEST["start_date"])
	{
		$this1->session->set_userdata($module_name."_start_date",$_REQUEST["start_date"]);
	}
	//.....................................................................................
	
	//end_date............................................................................
	if(!is_null($_REQUEST["end_date"]) && $_REQUEST["end_date"]=='')
	{
		$this1->session->unset_userdata($module_name."_end_date");
	}
	else if($_REQUEST["end_date"])
	{
		$this1->session->set_userdata($module_name."_end_date",$_REQUEST["end_date"]);
	}
	//.....................................................................................
	
	//per_page number of entries to show per page......................................................
	if(!is_null($_REQUEST["per_page"]) && $_REQUEST["per_page"]=='')
	{
		//common for all modules
		$this1->session->unset_userdata("per_page");
		//separate for modules
		//$this1->session->unset_userdata($module_name."_per_page");
	}
	else if($_REQUEST["per_page"])
	{
		//common for all modules
		$this1->session->set_userdata("per_page",$_REQUEST["per_page"]);
		//separate for modules
		//$this1->session->set_userdata($module_name."_per_page",$_REQUEST["per_page"]);
	}
	//end per_page number of entries to show per page......................................................
	
	//srch_txt............................................................................
	if(!is_null($_REQUEST["srch_txt"]) && $_REQUEST["srch_txt"]=='')
	{
		$this1->session->unset_userdata($module_name."_srch_txt");
	}
	else if($_REQUEST["srch_txt"])
	{
		$this1->session->set_userdata($module_name."_srch_txt",$_REQUEST["srch_txt"]);
	}
	//.....................................................................................
	
	
	//dropdown filters.....................................................................
	foreach($_REQUEST as $k=>$v)
	{
		if(stristr($k,'filter_'))
		{
			$this1->session->set_userdata($k,$v);
		}
	}
	//.....................................................................................
	
	//view filter icon/list................................................................
	if($_GET["view"])
	{
		$this1->session->set_userdata("view",$_GET["view"]);
	}
	//end view filter icon/list............................................................
	
	
}
/*--------------------------------------------------------------------------------------------------------*/




/*--------------------------------------------------------------------------------------------------------*/
//check if field name exists in a table
function fieldExists($table,$field)
{
    
$CI=& get_instance();

$arr=$CI->db->list_fields($table);
//var_export($arr);

if(in_array($field,$arr))
{
	return "found";
}

}
/*--------------------------------------------------------------------------------------------------------*/




/*--------------------------------------------------------------------------------------------------------*/
function get_arr_file_list($file_list,$folpath)
{

$arr=explode(";",$file_list);
//var_export($arr);

foreach($arr as $k=>$v)
{
	if(!$v){continue;}
	$filepath=$folpath.$v;
	
	//echo "<br/>$filepath";
	if(!is_file($filepath)){continue;}
	
	//echo "$filepath<br>";
	$arr_file_list[]=$v;
}

return $arr_file_list;

}
/*--------------------------------------------------------------------------------------------------------*/




/*--------------------------------------------------------------------------------------------------------*/
function getimgdim_restrict_wh($filename='',$max_width='',$max_height='')
{

if(!is_file("$filename"))
{
return;
}

$size=@getimagesize($filename);
$origwidth=$width=$size[0];
$origheight=$height=$size[1];

if($width>$max_width)
{
$per=$width/$max_width;
$width=round($width/$per);
$height=round($height/$per);
}

if($height>$max_height)
{
$per=$height/$max_height;
$width=round($width/$per);
$height=round($height/$per);
}

return array($width,$height,$origwidth,$origheight);

}
/*--------------------------------------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------------------------------------*/
//$name is the browse element/object name and not the name of the file browsed 
function multiple_upload($upload_dir = 'uploads', $name, $config = array())
{
    $CI =& get_instance();
    $files = array();

    if(empty($config))
    {
        $config['upload_path']   = realpath($upload_dir);
        $config['allowed_types'] = 'txt|gif|jpg|jpeg|jpe|bmp|png|doc|docx|pdf|xls|xlsx|csv|tiff';
        $config['max_size']      = '2048';
    }
        
        $CI->load->library('upload', $config);
        
        $errors = FALSE;
        
        foreach($_FILES as $key => $value)
        {   
			//var_export($_FILES['userfile']); exit;         
            //echo "$key->$value<br/>"; exit;
			
			if($key!=$name){continue;}
		
			if( ! empty($value['name']))
            {
                if( ! $CI->upload->do_upload($key))
                {                                           
                    $data['upload_message'] = $CI->upload->display_errors(ERR_OPEN, ERR_CLOSE); // ERR_OPEN and ERR_CLOSE are error delimiters defined in a config file
                    $CI->load->vars($data);
                        
                    $errors = TRUE;
                }
                else
                {
                    // Build a file array from all uploaded files
                    $files[] = $CI->upload->data();
                }
            }
        }
		//end foreach
        
        // There was errors, we have to delete the uploaded files
        if($errors)
        {                    
            foreach($files as $key => $file)
            {
                @unlink($file['full_path']);    
            }                    
        }
        elseif(empty($files) AND empty($data['upload_message']))
        {
            $CI->lang->load('upload');
            $data['upload_message'] = ERR_OPEN.$CI->lang->line('upload_no_file_selected').ERR_CLOSE;
            $CI->load->vars($data);
        }
        else
        {
			//return $files;
            foreach($files as $k=>$v){
				//echo "$k=>$v[file_name]<br/>";
				$filess[]=$v[file_name];
			}
			return $filess;
        }
    }
/*--------------------------------------------------------------------------------------------------------*/




/*--------------------------------------------------------------------------------------------------------*/
function datetime_mysql_to_ddmmyyyy($get_date)
{
    if(!$get_date){return;}
	$dt_explode=explode(" ",$get_date);
	$dt_explode=$dt_explode[0];
	 
	//echo $dt_explode;
	if($dt_explode=="0000-00-00"){return;} 
	//var_export($dt_explode); return;
	
	$dt_explode=explode("-",$dt_explode);
	$f_year=substr($dt_explode[0],0,4);
	$f_month=$dt_explode[1];
	$f_day=$dt_explode[2];
	
	$report_dt=$f_day."/".$f_month."/".$f_year;
	//echo $report_dt;
	return $report_dt;
		
}
/*--------------------------------------------------------------------------------------------------------*/




/*--------------------------------------------------------------------------------------------------------*/
function datetime_mysql_to_mmddyyyy($get_date)
{
  if(!$get_date){return;}
	$dt_explode=explode(" ",$get_date);
	$dt_explode=$dt_explode[0];
	 
	//echo $dt_explode;
	if($dt_explode=="0000-00-00"){return;} 
	//var_export($dt_explode); return;
	
	$dt_explode=explode("-",$dt_explode);
	$f_year=substr($dt_explode[0],0,4);
	$f_month=$dt_explode[1];
	$f_day=$dt_explode[2];
	
	$report_dt=$f_month."/".$f_day."/".$f_year;
	//echo $report_dt;
	return $report_dt;
		
}
/*--------------------------------------------------------------------------------------------------------*/




/*--------------------------------------------------------------------------------------------------------*/
function datetime_mysql_to_shortmonth($get_date)
{
    if(!$get_date){return;}
	$dt_explode=explode(" ",$get_date);
	$dt_explode=$dt_explode[0];
	 
	//echo $dt_explode;
	if($dt_explode=="0000-00-00"){return;} 
	//var_export($dt_explode); return;
	
	return strftime("%d-%b-%Y",strtotime($dt_explode));	
}
//datetime_mysql_to_shortmonth('2010-03-12 00:00:00');
/*--------------------------------------------------------------------------------------------------------*/




/*--------------------------------------------------------------------------------------------------------*/
function mmddyyyy_to_shortmonth($get_date)
{
    if(!$get_date){return;}
	$dt_explode=explode("/",$get_date);
	$dt_explode=$dt_explode[2]."-".$dt_explode[0]."-".$dt_explode[1];
	 
	return strftime("%d-%b-%Y",strtotime($dt_explode));	
}
//datetime_mysql_to_shortmonth('2010-03-12 00:00:00');
/*--------------------------------------------------------------------------------------------------------*/




/*--------------------------------------------------------------------------------------------------------*/
function datetime_mysql_to_time($get_date)
{
  if(!$get_date){return;}
	
	//echo $get_date;
	
	$dt_explode=explode(" ",$get_date);
	//echo $dt_explode[1];
	
	if($dt_explode[1]=="00:00:00"){return;}
	$time=explode(":",$dt_explode[1]);
	//echo $time[0];
	$time1=$time[0]<12 ? $time[0] : $time[0]-12;
	$time1=str_pad($time1,2,'0',STR_PAD_LEFT);
	$time1.=":".$time[1].":".$time[2];
	$time1.=$time[0]<12 ? " AM" : " PM";
	
	return $time1;
	
		
}
/*--------------------------------------------------------------------------------------------------------*/




/*--------------------------------------------------------------------------------------------------------*/
function select_dropdown($name,$query,$selected,$extra,$text="----Please Select----",$text_value='')
{

$CI=& get_instance();

//echo $extra;
$arr_selected=explode(",",$selected);

//if($size){ $size="multiple size='$size'";}
$name_simple=preg_replace("/\[\]/","",$name);

$query=$CI->db->query($query);
$result=$query->result_array();
//var_export($result);
	
echo "<select name='$name' id='$name_simple' $extra>";

if($text){
	echo "<option value='$text_value'>$text</option>";
}

foreach($result as $row)
{

$row=array_values($row);

?>
	<option value='<?php echo $row[0]?>' 
	<?php if(in_array($row[0],$arr_selected)){echo 'selected';}?> ><?php echo $row[1]?></option><br/>
<?php
}

echo "</select>";

}
/*--------------------------------------------------------------------------------------------------------*/




/*--------------------------------------------------------------------------------------------------------*/
function select_dropdown_int_desc($name,$max_val,$min_val,$selected,$extra,$text="Please Select")
{

//echo $extra;
$name_simple=preg_replace("/\[\]/","",$name);
echo "<select name='$name' id='$name_simple' $extra>";

//
if($text)
{
	echo "<option value=''>$text</option>";
}
//

//.......................................................................
for($i=$max_val;$i>=$min_val;$i--)
{
?>
	<option value='<?php echo $i?>' 
	<?php if($i==$selected){echo 'selected';}?> ><?php echo $i?>
	</option><br>
<?php
}
//.......................................................................

echo "</select>";
	
}
/*--------------------------------------------------------------------------------------------------------*/




/*--------------------------------------------------------------------------------------------------------*/
function select_dropdown_int($name,$min_val,$max_val,$selected,$extra,$text="Please Select")
{

//echo $extra;
$name_simple=preg_replace("/\[\]/","",$name);
echo "<select name='$name' id='$name_simple' $extra>";

//
if($text)
{
	echo "<option value=''>$text</option>";
}
//

//.......................................................................
for($i=$min_val;$i<=$max_val;$i++)
{
?>
	<option value='<?php echo $i?>' 
	<?php if($i==$selected){echo 'selected';}?> ><?php echo $i?>
	</option><br>
<?php
}
//.......................................................................

echo "</select>";
	
}
/*--------------------------------------------------------------------------------------------------------*/




/*--------------------------------------------------------------------------------------------------------*/
function display_images_height($arr_file_list,$folpath,$image_width)
{

//no image uploaded..........................................................................
if(count($arr_file_list)==0)
{
$filepath=base_url()."pics/default.png";
?>
<a href="<?php echo $filepath?>" class="thickbox">
<img src="<?php echo $filepath?>" border="0" /></a>
<?php
}
//...........................................................................................


//................................................................................................
foreach($arr_file_list as $k=>$v)
{
//if(!$v){continue;}
if(!$v){$filepath=base_url()."pics/default.png";}
else
{
	$filepath=base_url().$folpath.$v;
}
?>
<a href="<?php echo $filepath?>" class="thickbox">
<img src="<?php echo $filepath?>" border="0" /></a>
<?php
}
//................................................................................................
	
}
/*--------------------------------------------------------------------------------------------------------*/




/*--------------------------------------------------------------------------------------------------------*/
function display_images_with_print($module_name,$field_name,$id,$arr_file_list,$folpath,$image_width)
{

$CI=& get_instance();
$controller=$CI->uri->segment(1);
//echo $controller;

foreach($arr_file_list as $k=>$v)
{
	if(!$v){continue;}
	$filepath=$folpath.$v;
?>
	<a href="#" onclick="window.document.getElementById('image_print').print();">
	<img id="image_print" src="<?php echo $filepath?>" border="0" /></a>
	<br/><br/>
	[ <a href="#" onclick=jQuery("#image_print").print();><strong>Print</strong></a> ]
	<?php echo anchor(base_url()."$controller/module_form/$module_name/delete_file/$id/$v/$field_name",'Delete',
	array('class'=>'text_delete'));
}
	
}
/*--------------------------------------------------------------------------------------------------------*/




/*--------------------------------------------------------------------------------------------------------*/
//display_images_logo($module_name,"file_list",$record["id"],$arr_file_list,$folpath,$image_width);

function display_images_logo($module_name,$field_name,$id,$arr_file_list,$folpath,$image_width)
{

$CI=& get_instance();
$controller=$CI->uri->segment(1);
//echo $controller;

foreach($arr_file_list as $k=>$v)
{
	if(!$v){continue;}
	$filepath=$folpath.$v;
?>
	<img width="<?php echo $image_width?>" src="<?php echo $filepath?>" border="0" />
<?php
}
	
}
/*--------------------------------------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------------------------------------*/
//display_images_without_delete($module_name,"file_list",$record["id"],$arr_file_list,$folpath,$image_width);

function display_images_without_delete($module_name,$field_name,$id,$arr_file_list,$folpath,$image_width)
{

$CI=& get_instance();
$controller=$CI->uri->segment(1);
//echo $controller;

foreach($arr_file_list as $k=>$v)
{
	if(!$v){continue;}
	$filepath=$folpath.$v;
?>
	<a href="<?php echo $filepath?>" class="thickbox">
	<img width="<?php echo $image_width?>" src="<?php echo $filepath?>" border="0" /></a>
	<?php
}
	
}
/*--------------------------------------------------------------------------------------------------------*/




/*--------------------------------------------------------------------------------------------------------*/
//display_images_with_delete($module_name,"file_list",$record["id"],$arr_file_list,$folpath,$image_width);

function display_images_with_delete($module_name,$field_name,$id,$arr_file_list,$folpath,$image_width)
{

$CI=& get_instance();
$controller=$CI->uri->segment(1);
//echo $controller;

foreach($arr_file_list as $k=>$v)
{
	if(!$v){continue;}
	$filepath=$folpath.$v;
?>
	<a href="<?php echo $filepath?>" target="_blank">
	<img class="uploaded_image" style="width:<?php echo $image_width?>px" src="<?php echo $filepath?>" border="0" /></a>
	<?php echo anchor(base_url()."$controller/module_form/$module_name/delete_file/$id/$v/$field_name",'Delete',
	array('class'=>'text_delete'));
}
	
}
/*--------------------------------------------------------------------------------------------------------*/




?>