<div class="container">


<!--pre_defined_shape_modal-->
<div class="modal fade" id="pre_defined_shape_modal" role="dialog">
<div class="modal-dialog modal-sm">

  <!-- Modal content-->
  <div class="modal-content">
	<div class="modal-header">
	  <button type="button" class="close" data-dismiss="modal">&times;</button>
	  <h4 class="modal-title">Add a Pre-defined Shape</h4>
	</div>
	<div class="modal-body">
	  <p>
	  
	  <!--start row-->
	  <div class="row">
	  	<div class="col-md-3">Shape:</div>
		<div class="col-md-9">
			<select class="form-control" name="select_pre_defined_shape" id="select_pre_defined_shape" 
			onchange="return toggle_input()">
	  		<option value="rectangle">Rectangle</option>
			<option value="triangle">Triangle</option>
			<option value="circle">Circle</option>
	  		</select>
		</div>
	  </div>
	  <!--end row-->
	  
	  <!--start row-->
	  <div class="row" style="margin-top:5px">
	  	<div class="col-md-3">Unit:</div>
		<div class="col-md-9">
			<select class="form-control" name="select_pre_defined_unit" id="select_pre_defined_unit">
	  		<option value="feet">Feet</option>
			<option value="yards">Yards</option>
			<option value="meters">Meters</option>
			<option value="kilometers">Kilometers</option>
			<option value="miles">Miles</option>
	  		</select>
		</div>
	  </div>
	  <!--end row-->
	  
	  <!--start row-->
	  <div class="row" style="margin-top:5px">
	  	<div class="col-md-3">Width:</div>
		<div class="col-md-9">
			<input class="form-control" type="text" name="pre_defined_width" id="pre_defined_width">
		</div>
	  </div>
	  <!--end row-->
	  
	  <!--start row-->
	  <div class="row" style="margin-top:5px">
	  	<div class="col-md-3">Height:</div>
		<div class="col-md-9">
			<input class="form-control" type="text" name="pre_defined_height" id="pre_defined_height">
		</div>
	  </div>
	  <!--end row-->
	  
	  <!--start row-->
	  <div class="row" style="margin-top:5px; display:none">
	  	<div class="col-md-3">Radius:</div>
		<div class="col-md-9">
			<input class="form-control" type="text" name="pre_defined_radius" id="pre_defined_radius">
		</div>
	  </div>
	  <!--end row-->
	  
	  </p>
	</div>
	<div class="modal-footer">
	  <button type="button" class="btn btn-success" onClick="return add_shape()">Add Shape</button>
	  <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
	</div>
  </div>
  
</div>
</div>
<!--end pre_defined_shape_modal-->

  
</div>
<!--end container-->



<script>

//------------------------------------------------------------------------------------------------------------
function toggle_input()
{

var pre_defined_shape=jQuery("#select_pre_defined_shape").val();

//rectangle/triangle........................................................................
if(pre_defined_shape=='rectangle' || pre_defined_shape=='triangle')
{

//show/hide input
jQuery("#pre_defined_width").parent().parent().show();
jQuery("#pre_defined_height").parent().parent().show();
jQuery("#pre_defined_radius").parent().parent().hide();

}
//end rectangle/triangle....................................................................


//circle........................................................................
if(pre_defined_shape=='circle')
{

//show/hide input
jQuery("#pre_defined_width").parent().parent().hide();
jQuery("#pre_defined_height").parent().parent().hide();
jQuery("#pre_defined_radius").parent().parent().show();

}
//end circle....................................................................

}
//------------------------------------------------------------------------------------------------------------




//------------------------------------------------------------------------------------------------------------
function add_shape()
{

//.........................................................................
var pre_defined_shape=jQuery("#select_pre_defined_shape").val();
//alert(pre_defined_shape);

var pre_defined_unit=jQuery("#select_pre_defined_unit").val();
//alert(pre_defined_unit);

var pre_defined_width=jQuery("#pre_defined_width").val();
//alert(pre_defined_width);

var pre_defined_height=jQuery("#pre_defined_height").val();
//alert(pre_defined_height);

var pre_defined_radius=jQuery("#pre_defined_radius").val();
//alert(pre_defined_radius);

//.........................................................................


//rectangle........................................................................
if(pre_defined_shape=='rectangle')
{

var width=convert_unit_to_meter(pre_defined_unit,pre_defined_width);
var height=convert_unit_to_meter(pre_defined_unit,pre_defined_height);
//alert(width+', '+height);

predefined_rectangle(width,height);

}
//end rectangle....................................................................


//triangle........................................................................
if(pre_defined_shape=='triangle')
{

var width=convert_unit_to_meter(pre_defined_unit,pre_defined_width);
var height=convert_unit_to_meter(pre_defined_unit,pre_defined_height);
//alert(width+', '+height);

predefined_triangle(width,height);

}
//end triangle....................................................................


//circle........................................................................
if(pre_defined_shape=='circle')
{

var radius=convert_unit_to_meter(pre_defined_unit,pre_defined_radius);
//alert(radius);

predefined_circle(radius);

}
//end circle....................................................................



//hide modal
jQuery("#pre_defined_shape_modal").modal("hide");

}
//-----------------------------------------------------------------------------------------------------------




//converts all units to meter--------------------------------------------------------------------------------
function convert_unit_to_meter(unit_name,unit_value)
{

//
switch(unit_name)
{

case 'feet':
			return unit_value*0.3048;
			break;
case 'yards':
			return unit_value*0.9144;
			break;
case 'meters':
			return unit_value*1;
			break;
case 'kilometers':
			return unit_value*1000;
			break;
case 'miles':
			return unit_value*1609.34;
			break;

}
//

} 
//end converts all units to meter------------------------------------------------------------------------------

</script>
